<?php

declare(strict_types=1);

namespace Prism\Prism\Embeddings;

use Closure;
use Prism\Prism\Concerns\ChecksSelf;
use Prism\Prism\Concerns\HasProviderOptions;
use Prism\Prism\Contracts\PrismRequest;
use Prism\Prism\ValueObjects\Media\Image;

class Request implements PrismRequest
{
    use ChecksSelf, HasProviderOptions;

    /**
     * @param  array<string>  $inputs
     * @param  array<Image>  $images
     * @param  array<string, mixed>  $clientOptions
     * @param  array{0: array<int, int>|int, 1?: Closure|int, 2?: ?callable, 3?: bool}  $clientRetry
     * @param  array<string, mixed>  $providerOptions
     */
    public function __construct(
        protected string $model,
        protected string $providerKey,
        protected array $inputs,
        protected array $images,
        protected array $clientOptions,
        protected array $clientRetry,
        array $providerOptions = [],
    ) {
        $this->providerOptions = $providerOptions;
    }

    /**
     * @return array{0: array<int, int>|int, 1?: Closure|int, 2?: ?callable, 3?: bool} $clientRetry
     */
    public function clientRetry(): array
    {
        return $this->clientRetry;
    }

    /**
     * @return array<string, mixed> $clientOptions
     */
    public function clientOptions(): array
    {
        return $this->clientOptions;
    }

    /**
     * @return array<string> $inputs
     */
    public function inputs(): array
    {
        return $this->inputs;
    }

    /**
     * Get image inputs for embedding generation.
     *
     * @return array<Image>
     */
    public function images(): array
    {
        return $this->images;
    }

    /**
     * Check if the request contains image inputs.
     */
    public function hasImages(): bool
    {
        return $this->images !== [];
    }

    /**
     * Check if the request contains text inputs.
     */
    public function hasInputs(): bool
    {
        return $this->inputs !== [];
    }

    #[\Override]
    public function model(): string
    {
        return $this->model;
    }

    public function provider(): string
    {
        return $this->providerKey;
    }
}
