<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo e($subject); ?></title>
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: #f0f2f5;
            margin: 0;
            padding: 0;
            color: #333;
        }

        .container {
            max-width: 650px;
            margin: 40px auto;
            background-color: #ffffff;
            border-radius: 12px;
            overflow: hidden;
            box-shadow: 0 8px 20px rgba(0, 0, 0, 0.1);
            border-top: 6px solid #4a90e2;
        }

        .header {
            background: linear-gradient(90deg, #4a90e2, #50e3c2);
            color: #fff;
            text-align: center;
            padding: 25px 20px;
            font-size: 24px;
            font-weight: bold;
        }

        .content {
            padding: 25px 20px;
            line-height: 1.6;
        }

        .content p {
            margin: 12px 0;
        }

        .items {
            margin: 20px 0;
        }

        .items table {
            width: 100%;
            border-collapse: collapse;
        }

        .items th,
        .items td {
            padding: 12px 10px;
            border-bottom: 1px solid #eee;
            text-align: left;
        }

        .items th {
            background-color: #f7f9fc;
        }

        .badge {
            display: inline-block;
            padding: 5px 12px;
            border-radius: 12px;
            font-size: 12px;
            color: #fff;
            background: #4a90e2;
            margin-bottom: 10px;
        }

        .btn {
            display: inline-block;
            padding: 12px 25px;
            background: #50e3c2;
            color: #fff;
            border-radius: 6px;
            text-decoration: none;
            font-weight: bold;
            margin-top: 20px;
            transition: all 0.3s ease;
        }

        .btn:hover {
            background: #4a90e2;
        }

        .footer {
            background-color: #f0f2f5;
            text-align: center;
            color: #777;
            font-size: 12px;
            padding: 20px;
        }

        .icon {
            vertical-align: middle;
            width: 20px;
            height: 20px;
            margin-right: 6px;
        }
    </style>
</head>

<body>
    <div class="container">
        <div class="header">
            <span class="badge"><?php echo e($docType); ?></span> Notification
        </div>
        <div class="content">
            <p>Hello,</p>
            <p><?php echo e($body); ?></p>

            <?php if(!empty($items)): ?>
                <div class="items">
                    <?php
                        $showPrice = $docType !== 'pricerequest';
                        $totalHT = 0;
                        $totalTax = 0;
                    ?>

                    <table
                        style="width:100%; border-collapse: collapse; font-family: Arial, sans-serif; font-size: 14px;">
                        <thead>
                            <tr style="background-color:#4CAF50; color:#fff; text-align:left;">
                                <th style="padding:8px;">Référence</th>
                                <th style="padding:8px;">Nom</th>
                                <th style="padding:8px;">Quantité</th>
                                <?php if($showPrice): ?>
                                    <th style="padding:8px;">Prix Unitaire</th>
                                    <th style="padding:8px;">Total HT</th>
                                    <th style="padding:8px;">Taxe</th>
                                    <th style="padding:8px;">Total TTC</th>
                                <?php endif; ?>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $itemTotalHT = $showPrice ? $item['qty'] * $item['price'] : 0;
                                    $itemTax = $showPrice ? $itemTotalHT * ($item['tax']['value'] / 100) : 0;
                                    $itemTotalTTC = $itemTotalHT + $itemTax;

                                    $totalHT += $itemTotalHT;
                                    $totalTax += $itemTax;
                                ?>
                                <tr style="border-bottom:1px solid #ddd;">
                                    <td style="padding:8px;"><?php echo e($item['ref']); ?></td>
                                    <td style="padding:8px;"><?php echo e($item['name']); ?></td>
                                    <td style="padding:8px;"><?php echo e($item['qty']); ?></td>
                                    <?php if($showPrice): ?>
                                        <td style="padding:8px;"><?php echo e(number_format($item['price'], 2)); ?></td>
                                        <td style="padding:8px;"><?php echo e(number_format($itemTotalHT, 2)); ?></td>
                                        <td style="padding:8px;"><?php echo e(number_format($itemTax, 2)); ?></td>
                                        <td style="padding:8px;"><?php echo e(number_format($itemTotalTTC, 2)); ?></td>
                                    <?php endif; ?>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>

                        <?php if($showPrice): ?>
                            <tfoot>
                                <tr style="font-weight:bold; background-color:#f9f9f9;">
                                    <td colspan="4" style="text-align:right; padding:8px;">Total HT:</td>
                                    <td style="padding:8px;"><?php echo e(number_format($totalHT, 2)); ?></td>
                                    <td style="padding:8px;">Total Taxes:</td>
                                    <td style="padding:8px;"><?php echo e(number_format($totalTax, 2)); ?></td>
                                </tr>
                                <tr style="font-weight:bold; background-color:#f9f9f9;">
                                    <td colspan="6" style="text-align:right; padding:8px;">Total TTC:</td>
                                    <td style="padding:8px;"><?php echo e(number_format($totalHT + $totalTax, 2)); ?></td>
                                </tr>
                            </tfoot>
                        <?php endif; ?>
                    </table>

                    <p style="margin-top:20px; font-size:13px; color:#555;">
                        Ceci est un e-mail automatique, veuillez ne pas y répondre.
                    </p>

                </div>
            <?php endif; ?> 

            <div class="footer">
                LANESS S.A.R.L - All rights reserved. <br />
                <small>If you did not expect this email, please ignore it.</small>
            </div>
        </div>
    </div>
</body>

</html>
<?php /**PATH E:\proxywork-erp\proxywork-backend\resources\views\emails\operation.blade.php ENDPATH**/ ?>