<!DOCTYPE html>
<html lang="fr">

<head>
    <meta charset="UTF-8">
    <title><?php echo e(getDocTypeLabel($operation["docType"])); ?> - <?php echo e($operation["docId"]); ?></title>
    <style>
        :root {
            --primary-color: #000;
            --secondary-color: #555;
            --border-color: #DDD;
            --spacing-sm: 10px;
            --spacing-md: 15px;
            --spacing-lg: 20px;
            --spacing-xl: 40px;
            --font-size-base: 14px;
            --font-size-large: 16px;
            --font-size-small: 12px;
        }

        body {
            font-family: Arial, Helvetica, sans-serif;
            font-size: var(--font-size-base);
            color: var(--primary-color);
            margin: 0;
            padding: 0;
            position: relative;
        }

        .container {
            width: 100%;
            max-width: 210mm;
            /* A4 width */
            margin: 0 auto;
        }

        .bg {
            position: fixed;
            top: 50%;
            left: 50%;
            width: 600px;
            height: 600px;
            background: url("logo.png") center / contain no-repeat;
            opacity: 0.1;
            z-index: 0;
            transform: translate(-50%, -50%) rotate(45deg);
            /* rotate 45° */
        }


        .text-left {
            text-align: left !important;
        }

        .text-center {
            text-align: center !important;
        }

        .text-right {
            text-align: right !important;
        }

        .bold {
            font-weight: bold;
        }

        .italic {
            font-style: italic;
        }

        .no-border {
            border: none !important;
        }

        .vertical-top {
            vertical-align: top;
        }

        .vertical-middle {
            vertical-align: middle;
        }

        .mb-16 {
            margin-bottom: 16px;
        }

        .mt-20 {
            margin-top: var(--spacing-lg);
        }

        .mt-40 {
            margin-top: var(--spacing-xl);
        }

        /* Header */
        .header {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: var(--spacing-lg);
        }

        .logo-cell {
            width: 50%;
            vertical-align: middle;
        }

        .logo-cell img {
            width: 260px;
        }

        .logo {
            max-width: 200px;
            height: auto;
        }

        /* Flexbox solution */


        .slogan {
            text-align: right;
            vertical-align: middle;
            color: var(--secondary-color);
        }

        .merged-signature-wrapper {
            position: relative;
            display: inline-block;
            width: 200px;
            /* Adjust based on your images */
            height: 100px;
            margin: 0 auto;
        }

        .stamp-base {
            position: absolute;
            width: 100%;
            object-fit: contain;
            z-index: 1;
            opacity: 0.9;
            filter: brightness(1.1) contrast(0.9);
        }

        .signature-overlay {
            position: absolute;
            width: 70%;
            height: auto;
            object-fit: contain;
            z-index: 2;
            left: 50%;
            top: 30%;
            transform: translate(-50%, -50%);
            mix-blend-mode: multiply;
            opacity: 0.95;
        }


        /* Content Layout */
        .content-grid {
            width: 100%;
            border-collapse: collapse;
            margin: var(--spacing-lg) 0;
        }

        .content-grid td {
            border: none;
            vertical-align: top;
        }

        /* Document Info */
        .document-info {
            width: 70%;
            padding-right: var(--spacing-lg);
        }

        .contact-info {
            width: 30%;
        }

        .info-line {
            margin-bottom: var(--spacing-md);
            line-height: 1.4;
        }

        /* Document Title & Body */
        .document-title {
            margin: var(--spacing-md) 0;
            font-weight: bold;
            font-size: 1.1em;
        }

        .document-body {
            line-height: 1.6;
            margin-bottom: var(--spacing-xl);
        }

        /* Items Table */
        .items-table {
            margin-top: 20px;
            width: 100%;
            border-collapse: collapse;
            margin: var(--spacing-xl) 0;
            page-break-inside: avoid;
        }

        .items-table th,
        .items-table td {
            padding: var(--spacing-sm);
            border-bottom: 1px solid var(--border-color);
        }

        .items-table thead th {
            font-weight: bold;
            background-color: #f8f9fa;
        }

        .separator-row td {
            font-style: italic;
            padding-left: 14px;
            border-bottom: 1px solid var(--border-color);
        }

        /* Totals */
        .totals-container {
            width: 40%;
            margin-left: auto;
            margin-top: var(--spacing-md);
        }

        .totals-table {
            width: 100%;
            border-collapse: collapse;
        }

        .totals-table td {
            padding: 8px 4px;
            text-align: right;
            border-bottom: 1px solid var(--border-color);
        }

        .totals-table tr:last-child td {
            border-bottom: none;
            font-weight: bold;
        }

        .amount-in-words {
            margin-top: var(--spacing-md);
            font-style: italic;
            line-height: 1.4;
        }

        /* Operation Details */
        .operation-details {
            margin-top: var(--spacing-xl);
            width: 100%;
            border-collapse: collapse;
            border: none;
            page-break-inside: avoid;
        }

        .operation-details td {
            border: none;
            vertical-align: top;
        }

        .details-list {
            list-style: none;
            padding: 0;
            margin: 0;
        }

        .detail-item {
            margin-bottom: var(--spacing-sm);
        }


        /* Footer */
        .page-footer {
            position: fixed;
            bottom: 0px;
            left: 0;
            right: 0;
            height: 50px;
            font-size: var(--font-size-small);
            z-index: 1000;
        }

        .footer-content {
            width: 100%;
            border-collapse: collapse;
        }

        .footer-content td {
            border: none;
        }

        .company-info {
            line-height: 1.4;
        }

        .company-info strong {
            margin-right: 4px;
        }

        .pagination {
            white-space: nowrap;
            text-align: center;
            min-width: 100px;
        }

        /* Print Styles */
        @media print {
            body {
                font-size: var(--font-size-large);
            }

            .page-footer {
                position: fixed;
            }

            .items-table {
                page-break-inside: avoid;
            }

            .last-page-content {
                page-break-inside: avoid;
            }
        }

        .no-wrap {
            white-space: nowrap;
        }

        @page {
            margin: 50px 50px 50px 50px;
            footer: page-footer;
            header: page-header;
            size: A4;
        }

        .page-number:after {
            content: counter(page);
        }
    </style>
</head>

<body>
    <div <?php if($operationSettings['hasBackgroundLogo']): ?> style=" background-image: url('logo.png');" class="bg" <?php endif; ?>>
    </div>
    <?php if(isLegalOperation($operation["docType"])): ?>
    <footer class="page-footer">
        <table class="footer-content">
            <tr>
                <td class="text-right"><span> Page <span class="page-number"></span></span></td>
            </tr>
            <tr>
                <td class="text-center">
                    <div class="company-info">
                        <div><?php echo e($company["capital"] ?? ""); ?></div>
                        <strong>Patente:</strong><?php echo e($company["patent"]); ?>

                        <strong>RC:</strong><?php echo e($company["rc"]); ?>

                        <strong>IF:</strong><?php echo e($company["if"]); ?>

                        <strong>ICE:</strong><?php echo e($company["ice"]); ?>

                        <strong>CNSS:</strong><?php echo e($company["cnss"]); ?>

                        <strong>RIB:</strong><?php echo e($company["bank"]); ?>

                        <strong>Téléphone:</strong><?php echo e($company["phone"]); ?>

                        <strong>Email:</strong><?php echo e($company["email"]); ?>

                        <div><?php echo e($company["address"] ?? ""); ?></div>
                    </div>
                </td>
            </tr>
        </table>
    </footer>
    <?php endif; ?>

    <div class="container">
        <!-- Header -->
        <?php if($operationSettings['logoPosition']['value']==='left'): ?>
        <table class="header">
            <tr>
                <td class="logo-cell">
                    <img class="logo" src="logo.png" alt="<?php echo e($company[" name"] ?? ""); ?>">
                </td>
                <?php if($operationSettings['hasSlogen']): ?>
                <td class="slogan">
                    <?php echo e($company["slogan"]); ?><br>
                </td>
                <?php endif; ?>
            </tr>
        </table>
        <?php elseif($operationSettings['logoPosition']['value']==='right'): ?>
        <table class="header">
            <tr>
                <?php if($operationSettings['hasSlogen']): ?>
                <td class="slogan text-left">
                    <?php echo e($company["slogan"]); ?><br> Page <span class="page-number"></span>
                </td>
                <?php endif; ?>
                <td class="logo-cell  text-right">
                    <img class="logo" src="logo.png" alt="<?php echo e($company[" name"] ?? ""); ?>">
                </td>
            </tr>
        </table>
        <?php else: ?>
        <table class="header">
            <tr>
                <td class="text-center">
                    <div><img class="logo" src="logo.png" alt="<?php echo e($company[" name"] ?? ""); ?>"></div>
                </td>
            </tr>
            <?php if($operationSettings['hasSlogen']): ?>
            <tr>
                <td class="text-center">
                    <div> <?php echo e($company["slogan"]); ?><br> Page <span class="page-number"></span></div>
                </td>
            </tr>
            <?php endif; ?>
            <tr>
                <td class="text-center">
                    Page <span class="page-number"></span>
                </td>
            </tr>
        </table>
        <?php endif; ?>

        <!-- Document Information -->
        <table class="content-grid">
            <tr>
                <td class="document-info">
                    <div class="info-line bold title">
                        <h3><?php echo e(getDocTypeLabel($operation["docType"])); ?> N°:<?php echo e($operation["docId"] ?? ""); ?> </h3>
                    </div>
                    <div class="info-line">Date: <?php echo e($operation["date"]->format("d/m/Y") ?? ""); ?></div>
                    <?php if($operation["docType"] === "estimate" && $operation["validateDate"]): ?>
                    <div class="info-line"><?php echo e("Valide Jusqu'à"); ?> :
                        <?php echo e($operation["validateDate"]->format("d/m/Y") ?? ""); ?></div>
                    <?php endif; ?>
                    <?php if($operation["baseDocId"]): ?>
                    <div class="info-line">Référence: <?php echo e($operation["baseDocId"] ?? ""); ?></div>
                    <?php endif; ?>
                </td>
                <td class="contact-info">
                    <?php if(!isInternOperation($operation["docType"])): ?>
                    <?php echo e($operation["counterParty"]["name"] ?? ""); ?><br>
                    <?php echo e($operation["counterParty"]["address"]["street"] ?? ""); ?><br>
                    <?php echo e($operation["counterParty"]["address"]["city"] ?? ""); ?><br>
                    <?php echo e($operation["counterParty"]["address"]["country"] ?? ""); ?><br>
                    <?php echo e($operation["counterParty"]["address"]["zipCode"] ?? ""); ?><br>
                    <?php echo e($operation["counterParty"]["ice"] ?? ""); ?><br>
                    <?php echo e($operation["counterParty"]["contactPerson"] ?? ""); ?>

                    <?php else: ?>
                    <strong>Responsable <?php echo e("d'opération"); ?>:</strong>
                    <?php echo e($operation["personInCharge"] ?? ""); ?>

                    <?php endif; ?>
                </td>
            </tr>
        </table>

        <!-- Document Content -->
        <?php if($operation["subject"] && ($operation["docType"] === "purchaseorder" || $operation["docType"] ===
        "estimate")): ?>
        <div class="document-body"><?php echo nl2br(e($operation["body"])); ?></div>
        <?php endif; ?>

        <!-- Items Table -->
        <table class="items-table" style="page-break-after: auto;">
            <thead>
                <tr>
                    <th class="text-left">#</th>
                    <th class="text-left">Référence</th>
                    <th class="text-left">Désignation</th>
                    <th class="text-left">Quantité</th>
                    <?php if(hasPricing($operation["docType"])): ?>
                    <th class="text-left">Unité</th>
                    <th class="text-left  no-wrap">P.U (<?php echo e($operation["currency"]["code"]); ?>)</th>
                    <th class="text-left">Impôt</th>
                    <th class="text-right  no-wrap">Montant (<?php echo e($operation["currency"]["code"]); ?>)</th>
                    <?php endif; ?>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $operation["items"]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if($item["isSeparator"] ?? false): ?>
                <tr class="separator-row">
                    <td colspan="<?php echo e(hasPricing($operation->docType) ? 8 : 4); ?>">
                        <?php echo e($item["separatorName"] ?? ""); ?>

                    </td>
                </tr>
                <?php else: ?>
                <tr>
                    <td class="text-left"><?php echo e($item["id"] ?? ""); ?></td>
                    <td class="text-left"><?php echo e($item["ref"] ?? ""); ?></td>
                    <td class="text-left"><?php echo e($item["name"] ?? ""); ?></td>
                    <td class="text-left"><?php echo e(formatNumber($item["qty"] ?? 0)); ?></td>
                    <?php if(hasPricing($operation["docType"])): ?>
                    <td class="text-left"><?php echo e($item["unit"]['name'] ?? ""); ?></td>
                    <td class="text-left no-wrap"><?php echo e(formatNumber($item["price"] ?? 0)); ?> </td>
                    <td class="text-left">
                        
                        <?php if(!empty($item["tax"]) && is_array($item["tax"])): ?>
                        <?php echo e($item["tax"]["name"] ?? ""); ?>

                        <?php else: ?>
                        <!-- no tax -->
                        <?php endif; ?>
                    </td>
                    <td class="text-right no-wrap"><?php echo e(formatNumber($item["amount"] ?? 0)); ?> </td>
                    <?php endif; ?>
                </tr>
                <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>

        <?php if(hasPricing($operation["docType"])): ?>
        <!-- Totals Section -->
        <div class="totals-container">
            <table class="totals-table">
                <tr>
                    <td>Total HT :</td>
                    <td><?php echo e(formatNumber($operation["totalHt"]) ?? ""); ?>

                        <?php echo e($operation["currency"]["code"] ?? ""); ?></td>
                </tr>

                <?php if($operation["discount"] > 0): ?>
                <tr>
                    <td>Remise (<?php echo e(formatNumber(calculatePercentage($operation["totalHt"],$operation["discount"]))); ?>%) :
                    </td>
                    <td>-<?php echo e(formatNumber($operation["discount"]) ?? ""); ?>

                        <?php echo e($operation["currency"]["code"] ?? ""); ?></td>
                </tr>
                <tr>
                    <td>Total HT remisé :</td>
                    <td><?php echo e(formatNumber(safeSubtract($operation["totalHt"], $operation["discount"])) ?? ""); ?>

                        <?php echo e($operation["currency"]["code"]); ?></td>
                </tr>
                <?php endif; ?>

                <?php if($operation["tax"] && count($operation["tax"]) > 0): ?>
                <?php $__currentLoopData = $operation["tax"]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tax): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if(isset($tax["tax"]) && $tax["tax"] > 0): ?>
                <tr>
                    <td><?php echo e($tax["name"] ?? ""); ?> :</td>
                    <td><?php echo e(formatNumber($tax["tax"])); ?> <?php echo e($operation["currency"]["code"]); ?></td>
                </tr>
                <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>

                <tr>
                    <td class="bold">Total TTC :</td>
                    <td class="bold"><?php echo e(formatNumber($operation["totalTtc"] ?? 0)); ?>

                        <?php echo e($operation["currency"]["code"] ?? ""); ?></td>
                </tr>
            </table>
        </div>
        <?php if($operation["totalInWord"] && isLegalOperation($operation["docType"])): ?>
        <div class="amount-in-words"><?php echo nl2br(e($operation["totalInWord"])); ?></div>
        <?php endif; ?>
        <?php endif; ?>

        <!-- Operation Details & Signature -->
        <table class="operation-details last-page-content">
            <tr>
                <?php if(!isInternOperation($operation["docType"])): ?>
                <td width="70%">
                    <ul class="details-list">
                        <?php if($operation["conditions"]): ?>
                        <li class="detail-item">
                            <strong>Conditions:</strong> <?php echo e($operation["conditions"] ?? ""); ?>

                        </li>
                        <?php endif; ?>

                        <?php if($operation["paymentMethod"]): ?>
                        <li class="detail-item">
                            <strong>Modes de paiment:</strong>
                            <?php $__currentLoopData = $operation["paymentMethod"]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pm): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php echo e(getMethodOfPayment($pm['value']) ?? ""); ?>,
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </li>
                        <?php endif; ?>

                        <?php if($operation["paymentDue"]): ?>
                        <li class="detail-item">
                            <strong>Échéance:</strong>
                            <?php echo e($operation["paymentDue"]->format("d/m/Y") ?? ""); ?>

                        </li>
                        <?php endif; ?>

                        <?php if($operation["shippingChargeMode"]): ?>
                        <li class="detail-item">
                            <strong>Expédition:</strong>
                            <?php echo e(getModeShipping($operation["shippingChargeMode"]) ?? ""); ?>

                        </li>
                        <?php endif; ?>

                        <?php if($operation["shippingFees"] > 0): ?>
                        <li class="detail-item">
                            <strong>Frais:</strong> <?php echo e(formatNumber($operation["shippingFees"]) ?? ""); ?>

                            MAD
                        </li>
                        <?php endif; ?>

                        <?php if($operation["expectedArrival"]): ?>
                        <li class="detail-item">
                            <strong>Arrivée:</strong>
                            <?php echo e($operation["expectedArrival"]->format("d/m/Y") ?? ""); ?>

                        </li>
                        <?php endif; ?>
                    </ul>
                </td>
                <?php endif; ?>
                <?php if(isLegalOperation($operation['docType'] && ($operation["hasSignature"] ||$operation["hasStamp"]) )): ?>
                <td width="30%" class="signature-section">
                    <div class="signature-container">
                        <div class="signature-line">
                            <!-- Container for merged signature and stamp -->
                            <div class="merged-signature-wrapper">
                                <img src="stamp.png" alt="Company Stamp" class="stamp-base">
                                <img src="signature.png" alt="Signature" class="signature-overlay">
                            </div>
                        </div>
                    </div>
                </td>
                <?php endif; ?>
            </tr>
        </table>

        <?php if(!empty($operation["notes"])): ?>
        <div class="notes-section">
            <span class="notes-label"><strong>Notes:</strong></span>
            <ul>
                <?php $__currentLoopData = $operation["notes"]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $note): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li><?php echo e($note); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
        <?php endif; ?>
    </div>
</body>

</html><?php /**PATH E:\proxywork-erp\proxywork-backend\resources\views/operation/invoice.blade.php ENDPATH**/ ?>