<?php

use App\Http\Controllers\ACCOUNTING\AccountController;
use App\Http\Controllers\ACCOUNTING\AccountingentryController;
use App\Http\Controllers\ACCOUNTING\BankaccountController;
use App\Http\Controllers\ACCOUNTING\BankoperationController;
use App\Http\Controllers\ACCOUNTING\JournalController;
use App\Http\Controllers\ACCOUNTING\PaymentController;
use App\Http\Controllers\ACCOUNTING\PaymentmethodController;
use App\Http\Controllers\admin\AuditController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\auth\AuthController;
use App\Http\Controllers\admin\StatisticController;
use App\Http\Controllers\admin\IaController;
use App\Http\Controllers\admin\UserController;
use App\Http\Controllers\admin\RoleController;
use App\Http\Controllers\admin\PermissionController;
use App\Http\Controllers\admin\ColumnController;
use App\Http\Controllers\admin\LanguageController;
use \App\Http\Controllers\admin\SettingController;
use App\Http\Controllers\CRM\ClientController;
use App\Http\Controllers\CRM\SupplierController;
use App\Http\Controllers\HRM\AbsenceController;
use App\Http\Controllers\HRM\AdvanceController;
use App\Http\Controllers\HRM\AllowanceController;
use \App\Http\Controllers\HRM\EmployeeController;
use \App\Http\Controllers\HRM\AttendanceController;
use \App\Http\Controllers\HRM\AttendancelogController;
use App\Http\Controllers\HRM\CnssdeclarationController;
use App\Http\Controllers\HRM\CompensationController;
use App\Http\Controllers\HRM\DeductionController;
use App\Http\Controllers\HRM\LeaveController;
use \App\Http\Controllers\HRM\PayrollController;
use App\Http\Controllers\MEDIA\MediaController;
use \App\Http\Controllers\PRODUCT\ProductController;
use \App\Http\Controllers\PRODUCT\CategoryController;
use \App\Http\Controllers\PRODUCT\BrandController;
use \App\Http\Controllers\OPERATION\OperationController;
use App\Http\Controllers\OPERATION\PosController;
use App\Http\Controllers\PaymentmethodController as ControllersPaymentmethodController;
use App\Http\Controllers\PRODUCT\TaxController;
use App\Http\Controllers\PRODUCT\UnitController;
use App\Http\Controllers\STOCK\StocklogController;
use App\Http\Controllers\STOCK\WarehouseController;
use App\Http\Controllers\STOCK\ImmobilisationController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

// Dynamic model routes with Spatie permissions
$models = [
    'user' => UserController::class,
    'column' => ColumnController::class,
    'role' => RoleController::class,
    'permission' => PermissionController::class,
    'language' => LanguageController::class,
    'employee' => EmployeeController::class,
    'attendance' => AttendanceController::class,
    'attendancelog'=>AttendancelogController::class,
    'payroll'=> PayrollController::class,
    'allowance' => AllowanceController::class,
    'product' => ProductController::class,
    'category' => CategoryController::class,
    'brand' => BrandController::class,
    'operation' => OperationController::class,
    'supplier' => SupplierController::class,
    'client' => ClientController::class,
    'advance' =>AdvanceController::class,
    'deduction'=>DeductionController::class,
    'cnssdeclaration'=>CnssdeclarationController::class,
    'absence'=>AbsenceController::class,
    'leave'=>LeaveController::class,
    'media' => MediaController::class,
    'compensation'=> CompensationController::class,
    'setting'=> SettingController::class,
    'audit'=> AuditController::class,
    'stocklog'=> StocklogController::class,
    'warehouse'=> WarehouseController::class,
    'account'=>AccountController::class,
    'accountingentry'=>AccountingentryController::class,
    'bankaccount'=>BankaccountController::class,
    'bankoperation'=>BankoperationController::class,
    'journal'=>JournalController::class,
    'payment'=>PaymentController::class,
    'immobilisation'=>ImmobilisationController::class,
    'pos'=>PosController::class,
    'unit'=>UnitController::class,
    'tax' => TaxController::class,
    'paymentmethod'=>PaymentmethodController::class
];

foreach ($models as $model => $controller) {
    Route::prefix($model)->group(function () use ($controller, $model) {
        Route::get('', [$controller, 'index']);
        Route::post('', [$controller, 'store']);
        Route::patch('', [$controller, 'update']);
        Route::delete('', [$controller, 'destroy']);
        Route::post('clone', [$controller, 'clone']);
        Route::post('bulk-delete', [$controller, 'bulkDelete']);
        Route::put('bulk-update', [$controller, 'bulkUpdate']);
        Route::post('bulk-store', [$controller, 'bulkStore']);
        Route::get('export', [$controller, 'export']);
        Route::post('import', [$controller, 'import']);
        Route::get('example-csv', [$controller, 'csvExample']);
        Route::get('example-xlsx', [$controller, 'xlsxExample']);
        Route::post('upload', [$controller, 'upload']);
        Route::post('download', [$controller, 'download']);
        Route::get('listnames', [$controller, 'getDataAsArrayOfNames']);

    });
}


// permission and roles
Route::get('group-permissions', [PermissionController::class, 'getAllPermissionsRegrouped'])->middleware('auth:api');
Route::post('assign-permissions', [PermissionController::class, 'assignPermissionsToRole'])->middleware('auth:api');
Route::get('module-column', [RoleController::class, 'getModules']);
Route::get('role-column', [RoleController::class, 'getRoleColumn'])->middleware('auth:api');
Route::post('role-column', [RoleController::class, 'storeRoleColumn'])->middleware('auth:api');
Route::get('role-filter', [RoleController::class, 'getRoleFilter'])->middleware('auth:api');
Route::post('role-filter', [RoleController::class, 'storeRoleFilter'])->middleware('auth:api');
Route::get('role-menu', [RoleController::class, 'getRoleMenu'])->middleware('auth:api');
Route::post('role-menu', [RoleController::class, 'storeRoleMenu'])->middleware('auth:api');

// Auth routes (public)
Route::group(['prefix' => 'auth'], function () {
    Route::post('login', [AuthController::class, 'login']);
    Route::post('register', [AuthController::class, 'register']);
    Route::post('logout', [AuthController::class, 'logout'])->middleware('auth:api');
    Route::get('check', [AuthController::class, 'check'])->middleware('auth:api');
    Route::post('change-password', [AuthController::class, 'changePassword'])->middleware('auth:api');
});

//printing  invoices
Route::post('print-inv', [OperationController::class, 'printInvoice'])->middleware('auth:api');
Route::post('download-inv', [OperationController::class, 'downloadInvoice'])->middleware('auth:api');


//helpers--------------------------
Route::post('attlog', [AttendancelogController::class, 'readAttLog'])->middleware('auth:api');
Route::get('generate-operation-number', [OperationController::class, 'generateInvoiceNumber'])->middleware('auth:api');
Route::post('send', [OperationController::class, 'sendBulkMail'])->middleware('auth:api');
Route::post('generate-attendances', [AttendanceController::class, 'generateAttendances'])->middleware('auth:api');


//statistics
Route::get('hrm-data', [StatisticController::class, 'hrmData'])->middleware('auth:api');
Route::get('sale-data', [StatisticController::class, 'saleData']);

//Chat boot
Route::post('chat', [IaController::class, 'chat']);
