<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class SettingSeeder extends Seeder
{
    public function run()
    {
        $companySettings = [
            'logo' => null,
            'stamp' => null,
            'signature' => null,
            'name' => 'My Company',
            'slogan' => 'Innovation at Work',
            'managerName' => 'John Doe',
            'managerID' => 'JD123456',
            'managerAvatar' => null,
            'managerSignature' => null,
            'managerStamp' => null,
            'rc' => '123456',
            'legalName' => 'My Company SARL',
            'if' => '654321',
            'cnss' => 'CNSS123456',
            'ice' => 'ICE123456',
            'patent' => 'PAT123456',
            'address' => null,
            'bank' => 'Bank Name',
            // SMTP
            'host' => 'smtp.mailtrap.io',
            'port' => '2525',
            'encryption' => 'tls',
            'username' => 'user',
            'password' => 'password',
            'fromName' => 'My Company',
            'fromAddress' => 'noreply@mycompany.com',
            'testRecipient' => 'test@mycompany.com',
        ];

        $hrmSettings = [
            'supplementary_types' => [
                'suppDay' => ['label' => 'Heures supplémentaires de jour', 'rate' => 1.25, 'rateLabel' => '+25%'],
                'suppNight' => ['label' => 'Heures supplémentaires de nuit', 'rate' => 1.5, 'rateLabel' => '+50%'],
                'suppHoly' => ['label' => 'Heures jours fériés', 'rate' => 2.0, 'rateLabel' => '+100%'],
                'weekend' => ['label' => 'Heures week-end', 'rate' => 1.5, 'rateLabel' => '+50%'],
            ],
            'cnss_employee_rate' => 0.0429,
            'cnss_employer_rate' => 0.086,
            'cnss_total_rate' => 0.1289,
            'cnss_cap' => 6000,
            'cnss_rate' => 0.0448,
            'cnss_floor' => 3266.1,
            'family_allowance_rate' => 0.064,
            'family_allowance_cap' => 6000,
            'amo_employee_rate' => 0.0185,
            'amo_employer_rate' => 0.0411,
            'amo_total_rate' => 0.0637,
            'amo_cap' => null,
            'amo_rate' => 0.0231,
            'amo_floor' => 3266.1,
            'ipe_employee_rate' => 0.0019,
            'ipe_employer_rate' => 0.0038,
            'ipe_total_rate' => 0.0057,
            'ipe_cap' => 6000,
            'tfp_employee_rate' => 0.0,
            'tfp_employer_rate' => 0.016,
            'tfp_total_rate' => 0.016,
            'tfp_cap' => null,
            'smig_hourly' => 17.1,
            'smig_monthly_hours' => 191,
            'smig_monthly' => 3266.1,
            'loss_job_rate' => 0.0021,
            'loss_job_cap' => 7000,
            'loss_job_floor' => 3266.1,
            'pro_fees_rate_low' => 0.35,
            'pro_fees_rate_high' => 0.25,
            'pro_fees_threshold' => 6500,
            'pro_fees_cap' => 2500,
            'pro_fees_cap_per_year' => 30000,
            'ir_brackets' => [
                ['max' => 3333.33, 'rate' => 0.0, 'deduction' => 0],
                ['max' => 5001.0, 'rate' => 0.1, 'deduction' => 333.33],
                ['max' => 6666.67, 'rate' => 0.2, 'deduction' => 833.33],
                ['max' => 8333.33, 'rate' => 0.3, 'deduction' => 1500],
                ['max' => 15000.0, 'rate' => 0.34, 'deduction' => 1833.33],
                ['max' => null, 'rate' => 0.37, 'deduction' => 2283.33],
            ],
            'tax_credit_per_dependent' => 41.67,
            'family_charge_per_child' => 41.67,
            'family_charge_married_no_children' => 41.67,
            'family_charge_max' => 180,
            'exemption_limits' => [
                'transport' => 500,
                'meal' => 300,
                'family' => 300,
                'housing' => 2500,
            ],
            'supp_rates' => [
                'regular' => 1.0,
                'day' => 1.25,
                'night' => 1.5,
                'holy' => 2.0,
                'weekend' => 1.5,
            ],
            'retirement_min_days' => 3240,
            'retirement_base_rate' => 0.5,
            'retirement_bonus_days' => 216,
            'retirement_bonus_rate' => 0.01,
            'retirement_max_rate' => 0.7,
            'retirement_average_months' => 96,
        ];

        // Check if settings table already has a row
        $exists = DB::table('settings')->exists();

        if ($exists) {
            // Update the first row
            DB::table('settings')->update([
                'company' => json_encode($companySettings),
                'hrm' => json_encode($hrmSettings)
            ]);
        } else {
            // Insert a new row
            DB::table('settings')->insert([
                'company' => json_encode($companySettings),
                'hrm' => json_encode($hrmSettings),
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }
    }
}

