<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\admin\User;
use Spatie\Permission\Models\Role;

class AssignAdminRoleSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $user = User::find(1);
        $role = Role::find(1);
        if ($user && $role) {
            $user->assignRole($role);
            $this->command->info("✅ Admin role assigned to User ID 1");
        } else {
            $this->command->warn("⚠️ User or Role not found!");
        }
    }
}
