<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('immobilisations', function (Blueprint $table) {
           $table->id();
            // Relations
            $table->unsignedBigInteger('productId');
            $table->foreign('productId')->references('id')->on('products')->onDelete('cascade');
            // Acquisition
            $table->date('acquisitionDate');
            $table->decimal('acquisitionQty', 15, 2);
            $table->decimal('acquisitionValue', 15, 2);
            // Amortisation
            $table->unsignedInteger('amortisationYears');
            $table->decimal('amortisationRate', 5, 2)->nullable();
            $table->decimal('annualAmortisation', 15, 2)->nullable();
            $table->decimal('accumulatedAmortisation', 15, 2)->default(0);
            $table->decimal('netBookValue', 15, 2);
            // Status
            $table->string('status')->nullable();
            // Meta
            $table->text('notes')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('immobilisations');
    }
};
