<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('bankoperations', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('bankaccountId')->nullable();
            $table->foreign('bankaccountId')->references('id')->on('bankaccounts')->onDelete('set null');
            $table->json('operationIds');
            $table->decimal('amount', 15, 3)->default(0);
            $table->string('operationType');// 'deposit' or 'withdrawal'
            $table->string('description')->nullable();
            $table->date('operationDate');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('bankoperations');
    }
};
