<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('accountingentries', function (Blueprint $table) {
            $table->id();

            $table->unsignedBigInteger('operationId')->nullable();
            $table->foreign('operationId')->references('id')->on('operations')->onDelete('set null');

            $table->unsignedBigInteger('journalId')->nullable();
            $table->foreign('journalId')->references('id')->on('journals')->onDelete('set null');

             $table->unsignedBigInteger('accountId')->nullable();
            $table->foreign('accountId')->references('id')->on('accounts')->onDelete('set null');

            $table->decimal('debit', 15, 3)->default(0);
            $table->decimal('credit', 15, 3)->default(0);

            $table->date('entryDate');
            $table->timestamps();

            $table->index(['operationId', 'accountId']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('accountingentries');
    }
};
