<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('rooms', function (Blueprint $table) {
            $table->id();

            // Basic info
            $table->string('roomNumber')->unique();   // numéro de chambre
            $table->string('name')->nullable();       // optional name (ex: Suite Atlas)
            $table->string('type');                   // single, double, suite, family...

            // Pricing
            $table->decimal('basePrice', 10, 2)->default(0);   // prix par nuit
            $table->decimal('extraAdultPrice', 10, 2)->default(0);
            $table->decimal('extraChildPrice', 10, 2)->default(0);

            // Capacity
            $table->integer('maxAdults')->default(1);
            $table->integer('maxChildren')->default(0);
            $table->integer('maxOccupancy')->default(1);

            // Characteristics
            $table->string('floor')->nullable();
            $table->json('bedType')->nullable();     // queen, twin, king...
            $table->json('amenities')->nullable();     // wifi, TV, AC, minibar...

            // Status
           $table->string('status')->nullable();

            // Descriptions & Media
            $table->longText('description')->nullable();
            $table->json('images')->nullable();
            $table->json('videos')->nullable();
            $table->json('features')->nullable();
            $table->json('tags')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('rooms');
    }
};
