<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('stocklogs', function (Blueprint $table) {
            $table->id();
            $table->string('batch')->nullable();
            // $table->integer('productId')->nullable(); this should be a foreign key
            $table->unsignedBigInteger('productId')->nullable();
            $table->foreign('productId')->references('id')->on('products');
            $table->unsignedBigInteger('operationId')->nullable();
            $table->foreign('operationId')->references('id')->on('operations');
            $table->unsignedBigInteger('warehouseId')->nullable();
            $table->foreign('warehouseId')->references('id')->on('warehouses');
            $table->string('productName')->nullable();
            $table->string('productCode')->nullable();
            $table->string('operationType')->nullable();
            $table->string('operationCode')->nullable();
            $table->integer('quantity')->nullable();
            $table->decimal('price', 15, 3)->nullable()->default(0);
            $table->string('unite')->nullable();
            $table->string('operator')->nullable();
            $table->integer('operatorId')->nullable();
            $table->string('warehouse')->nullable();
            $table->string('date')->nullable();
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('stocklogs');
    }
};
