<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('compensation', function (Blueprint $table) {
            $table->id();
            $table->string('uid')->unique();
            $table->string('status')->nullable()->default('pending'); //if this change to epproved the set the epproved by the user authenticated and epproved date
            $table->string('name')->nullable();
            $table->integer('employee_id')->nullable();
            $table->integer('allowance_id')->nullable();
            $table->date('dueDate')->nullable();//
            $table->json('employee')->nullable();//
            $table->json('allowance')->nullable();//
            $table->string('approvedBy')->nullable();
            $table->date('approvedAt')->nullable();
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('compensation');
    }
};
