<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('clients', function (Blueprint $table) {
            $table->id();
            $table->uuid('uid')->unique();                   // Unique ID auto-generated
            $table->string('name')->nullable();                          // اسم المورد
            $table->string('status')->nullable()->default('active');     // active / inactive
            $table->string('ice')->nullable();               // Identifiant Commun de l'Entreprise
            $table->string('rc')->nullable();                // Registre de Commerce
            $table->string('taxNumber')->nullable();        // رقم ضريبي (optional)
            $table->string('email')->nullable();             // البريد الإلكتروني
            $table->string('phone')->nullable();             // رقم الهاتف
            $table->json('address')->nullable();           // العنوان
            $table->string('contactPerson')->nullable();    // الشخص المسؤول
            $table->decimal('balance', 15, 2)->default(0);    // رصيد المورد الحالي
            $table->decimal('turnover', 15, 2)->default(0);  // Chiffre d'affaire
            $table->string('paymentPerms')->nullable();     // شروط الدفع
            $table->text('description')->nullable();         // ملاحظات إضافية
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('clients');
    }
};
