<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('attendancelogs', function (Blueprint $table) {
            $table->id();
            $table->string('uid')->unique();
            $table->string('name')->nullable();
            $table->integer('employee_id')->nullable();
            $table->integer('employee_pid')->nullable();
            $table->string('status')->nullable()->default('active');
            $table->json('employee')->nullable();
            $table->date('date')->nullable();
            $table->datetime('time')->nullable();
            $table->string('type')->nullable(); // checkin or checkout
            $table->boolean('isToken')->nullable(); // 1 or 0
            $table->text('comment')->nullable();
            $table->unique(['employee_pid', 'date', 'time', 'type']);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('attendancelogs');
    }
};
