<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('cnssdeclarations', function (Blueprint $table) {
            $table->id();
            $table->string('uid')->unique();
            $table->string('name')->nullable();
            $table->integer('employee_id')->nullable();
            $table->integer('employee_pid')->nullable();
            $table->string('status')->nullable()->default('active');
            // معلومات الموظف
            $table->json('employee')->nullable();
            $table->string('month')->nullable();
            $table->integer('amount')->nullable();
            $table->integer('days')->nullable();
            $table->decimal('hours', 18, 4)->nullable();
            $table->decimal('salary', 18, 4)->nullable();
            $table->text('observation')->nullable();

            $table->softDeletes();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('cnssdeclarations');
    }
};
