<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('operations', function (Blueprint $table) {
            $table->id();

            // identifiers
            $table->string('uid')->unique();
            $table->string('docId')->nullable();
            $table->string('baseDocId')->nullable();
            $table->string('name');

            // type & status
            $table->string('status')->nullable();
            $table->string('docType')->nullable();

            // dates
            $table->datetime('date')->nullable();
            $table->datetime('dueDate')->nullable();
            $table->datetime('validateDate')->nullable();


            // payment
            $table->datetime('paymentDue')->nullable();
            $table->json('paymentMethod')->nullable();

            // financials
            $table->decimal('totalHt', 12, 2)->nullable()->default(0);
            $table->decimal('totalTtc', 12, 2)->nullable()->default(0);
            $table->decimal('realCostTotalHt', 12, 2)->nullable()->default(0);
            $table->decimal('estimateCostTotalHt', 12, 2)->nullable()->default(0);
            $table->decimal('grandTotal', 12, 2)->nullable()->default(0);
            $table->decimal('discount', 12, 2)->nullable()->default(0);
            $table->json('tax')->nullable();
            $table->string('totalInWord')->nullable();

            // logistic
            $table->string('shippingChargeMode')->nullable();
            $table->decimal('shippingFees', 12, 2)->nullable()->default(0);
            $table->datetime('expectedArrival')->nullable();
            $table->json('shippingMethod')->nullable();
            $table->json('currency')->nullable();

            // contact & extra
            $table->string('subject')->nullable();
            $table->longText('body')->nullable();
            $table->json('notes')->nullable();
            $table->json('counterParty')->nullable();
            $table->json('sendTo')->nullable();
            $table->longText('conditions')->nullable();
            $table->json('items')->nullable();

            $table->string('personInCharge')->nullable();

            // relationships
            $table->unsignedBigInteger('parentId')->nullable();
            $table->foreign('parentId')->references('id')->on('operations')->onDelete('set null');

            $table->unsignedBigInteger('invoiceId')->nullable();
            $table->foreign('invoiceId')->references('id')->on('operations')->onDelete('set null');

            $table->unsignedBigInteger('userId')->nullable();
            $table->foreign('userId')->references('id')->on('users')->onDelete('set null');

            $table->unsignedBigInteger('warehouseId')->nullable();
            $table->foreign('warehouseId')->references('id')->on('warehouses')->onDelete('set null');

            $table->unsignedBigInteger('fromWarehouseId')->nullable();
            $table->foreign('fromWarehouseId')->references('id')->on('warehouses')->onDelete('set null');

            $table->unsignedBigInteger('toWarehouseId')->nullable();
            $table->foreign('toWarehouseId')->references('id')->on('warehouses')->onDelete('set null');

            $table->unsignedBigInteger('tableId')->nullable();
            $table->foreign('tableId')->references('id')->on('tables')->onDelete('set null');

            $table->unsignedBigInteger('roomId')->nullable();
            $table->foreign('roomId')->references('id')->on('rooms')->onDelete('set null');

            $table->unsignedBigInteger('supplierId')->nullable();
            $table->foreign('supplierId')->references('id')->on('suppliers')->onDelete('set null');

            $table->unsignedBigInteger('clientId')->nullable();
            $table->foreign('clientId')->references('id')->on('clients')->onDelete('set null');

            $table->unsignedBigInteger('posId')->nullable();
            $table->foreign('posId')->references('id')->on('pos')->onDelete('set null');

            //is entry to the stockLogs
            $table->boolean('isInWarehouse')->nullable()->default(false);
            $table->boolean('hasSignature')->nullable()->default(false);
            $table->boolean('hasStamp')->nullable()->default(false);
       



            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('operations');
    }
};
