<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('products', function (Blueprint $table) {
            /* -------------------------------------------------
             | Primary & Identifiers
             |--------------------------------------------------*/
            $table->id();
            $table->string('uid')->unique();
            $table->string('ref')->nullable()->unique();
            /* -------------------------------------------------
             | Basic Information
             |--------------------------------------------------*/
            $table->string('name')->nullable();
            $table->string('status')->nullable()->default('active');
            $table->text('description')->nullable();
            $table->json('type')->nullable();

            /* -------------------------------------------------
             | Classification & Metadata
             |--------------------------------------------------*/
            $table->json('category')->nullable();
            $table->json('brand')->nullable();
            $table->json('attribute')->nullable();
            $table->boolean('hasAttribute')->nullable()->default(false);


            /* -------------------------------------------------
             | Units & Physical Properties
             |--------------------------------------------------*/
            $table->json('unit')->nullable();
            $table->decimal('volume', 15, 2)->nullable();
            $table->decimal('weight', 15, 2)->nullable();
            $table->decimal('itemInBox', 15, 2)->nullable();
            $table->string('dimension')->nullable();

            /* -------------------------------------------------
             | Pricing & Tax
             |--------------------------------------------------*/
            $table->decimal('salePrice', 15, 2)->nullable();
            $table->decimal('costPrice', 15, 2)->nullable();
            $table->json('tax')->nullable();

            /* -------------------------------------------------
             | Inventory Control
             |--------------------------------------------------*/
            $table->decimal('minStock', 18, 2)->nullable();
            $table->decimal('maxStock', 18, 2)->nullable();
            $table->string('location')->nullable();

            /* -------------------------------------------------
             | BOM & Documents & VARIANT
             |--------------------------------------------------*/
            $table->json('bom')->nullable();
            $table->json('variant')->nullable();
            $table->json('images')->nullable();
            $table->json('documents')->nullable();

            /* -------------------------------------------------
             | Flags
             |--------------------------------------------------*/
            $table->boolean('favorite')->default(false);
            $table->boolean('sellable')->default(true);
            $table->boolean('buyable')->default(true);

            /* -------------------------------------------------
             | expiration
             |--------------------------------------------------*/

             $table->boolean('hasExpiration')->nullable();

            /* -------------------------------------------------
             | Immobilisation
             |--------------------------------------------------*/
             $table->unsignedInteger('amortisationYears')->nullable();
             $table->decimal('amortisationRate', 5, 2)->nullable();
             $table->decimal('annualAmortisation', 15, 2)->nullable();
             $table->text('descriptionImmobilisation')->nullable();
            /* -------------------------------------------------
             | Indexes & Timestamps
             |--------------------------------------------------*/

            $table->timestamps();
            $table->softDeletes();

            $table->index('name');
            $table->index('ref');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('products');
    }
};
