<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */

    public function up(): void
    {
        Schema::create('columns', function (Blueprint $table) {
            $table->id();
            $table->string('uid')->unique();
            $table->string('name');
            $table->string('type')->nullable();
            $table->string('objectView')->nullable();
            $table->string('route')->nullable();
            $table->string('icon')->nullable();
            $table->string('iconClickAction')->nullable();
            $table->boolean('isHumanDate')->default(false);
            $table->boolean('isClickable')->default(false);
            $table->boolean('isVisible')->default(true);
            $table->boolean('isNumber')->default(false);
            $table->json('options')->nullable();
            $table->json('optStatus')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('columns');
    }
};
