<?php
namespace App\data;

use App\Models\admin\Setting;

class CompanyDTO
{
    public string $name;
    public string $address;
    public string $phone;
    public string $logo;

    public function __construct(Setting $setting)
    {
        $this->name    = $setting->company_name;
        $this->address = $setting->address;
        $this->phone   = $setting->phone;
        $this->logo    = asset('storage/' . $setting->logo);
    }

    public function toArray(): array
    {
        return get_object_vars($this);
    }
}
