<?php
namespace App\data;

use App\Models\OPERATION\Operation;
use App\data\operation\OperationItemDTO;

class OperationDTO
{
    public string $uid;
    public ?string $docId;
    public ?string $name;
    public ?string $status;
    public ?string $docType;

    public ?string $date;
    public ?string $dueDate;
    public ?string $validateDate;

    public ?string $paymentMethod;
    public ?string $paymentDue;

    public float $totalHt;
    public float $totalTtc;
    public float $grandTotal;
    public float $discount;
    public string $totalInWord;

    public array $tax = [];
    public array $items = [];

    public function __construct(Operation $op)
    {
        // base fields
        $this->uid   = $op->uid;
        $this->docId = $op->docId;
        $this->name  = $op->name;
        $this->status = $op->status;
        $this->docType = $op->docType;

        // dates
        $this->date = optional($op->date)->format('Y-m-d H:i');
        $this->dueDate = optional($op->dueDate)->format('Y-m-d H:i');
        $this->validateDate = optional($op->validateDate)->format('Y-m-d H:i');

        // payment
        $this->paymentMethod = $op->paymentMethod;
        $this->paymentDue = optional($op->paymentDue)->format('Y-m-d H:i');

        // financials
        $this->totalHt    = (float)$op->totalHt;
        $this->totalTtc   = (float)$op->totalTtc;
        $this->grandTotal = (float)$op->grandTotal;
        $this->discount   = (float)$op->discount;
        $this->totalInWord = $op->totalInWord ?? '';

        // taxes (operation level)
        $this->tax =[];

        // items
        $this->items = collect($op->items ?? [])
            ->map(fn($item) => (new ItemDTO($item))->toArray())
            ->toArray();
    }

    public function toArray(): array
    {
        return get_object_vars($this);
    }
}

