<?php

namespace App\Services;


use Illuminate\Support\Facades\Cache;
use App\Models\PRODUCT\Product;

class ProductCacheService
{
    const CACHE_KEY = 'products:autocomplete';

    public static function get()
    {
        return Cache::rememberForever(self::CACHE_KEY, function () {
            return Product::query()
                ->select('*')
                ->selectSub(function ($q) {
                    $q->from('stocklogs')
                        ->selectRaw("
                            COALESCE(SUM(
                                CASE
                                    WHEN operationType = 'entrynote' THEN quantity
                                    WHEN operationType = 'adjustmentnote' THEN quantity
                                    WHEN operationType = 'exitnote' THEN -quantity
                                    ELSE 0
                                END
                            ), 0)
                        ")
                        ->whereNull('stocklogs.deleted_at')
                        ->whereColumn('stocklogs.productId', 'products.id');
                }, 'stock')
                ->selectSub(function ($q) {
                    $q->from('stocklogs')
                        ->select('price')
                        ->whereColumn('stocklogs.productId', 'products.id')
                        ->whereNotNull('price')
                        ->whereNull('stocklogs.deleted_at')
                        ->orderBy('created_at', 'desc')
                        ->limit(1);
                }, 'operationPrice')
                ->get();
        });
    }

    public static function clear()
    {
        Cache::forget(self::CACHE_KEY);
    }
}
