<?php

namespace App\Observers;

use App\Models\OPERATION\Operation;
use App\Models\ACCOUNTING\Payment;

class InvoiceSaleObserver
{
    /**
     * Handle the Operation "created" event.
     */
    public function created(Operation $operation): void
    {
       // only for invoice sale
        if ($operation->docType !== 'invoicesale') {
            return;
        }

        // safety: no duplicate payment
        if ($operation->payments()->exists()) {
            return;
        }

        Payment::create([
            'operationId'   => $operation->id,
            'operationType' => $operation->docType,
            'amount'        => (float) $operation->totalTtc,
            'status'        => 'pending',
            'paymentDate'   => now(),
            'currency'      => $operation->currency,
            'counterParty'  => $operation->counterParty,
            'paymentMethod'=> $operation->paymentMethod ?? null,
        ]);
    }

    /**
     * Handle the Operation "updated" event.
     */
    public function updated(Operation $operation): void
    {
        //
    }

    /**
     * Handle the Operation "deleted" event.
     */
    public function deleted(Operation $operation): void
    {
        //
    }

    /**
     * Handle the Operation "restored" event.
     */
    public function restored(Operation $operation): void
    {
        //
    }

    /**
     * Handle the Operation "force deleted" event.
     */
    public function forceDeleted(Operation $operation): void
    {
        //
    }
}
