<?php

namespace App\Models\admin;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;
use Illuminate\Database\Eloquent\Casts\Attribute;

class Column extends Model
{
    protected $fillable = [
        'name',
        'type',
        'objectView',
        'route',
        'icon',
        'iconClickAction',
        'isHumanDate',
        'isClickable',
        'isVisible',
        'isNumber',
        'options',
        'optStatus',
    ];

    protected $casts = [
        'isHumanDate' => 'boolean',
        'isClickable' => 'boolean',
        'isVisible' => 'boolean',
        'isNumber' => 'boolean',
        'options' => 'array',
        'optStatus' => 'array',
    ];

    protected static function boot()
    {
        parent::boot();
        static::creating(function ($model) {
            if (empty($model->uid)) {
                $model->uid = (string) Str::ulid();
            }
        });
    }

    protected function options(): Attribute
    {
        return Attribute::make(
            get: fn($value) => json_decode($value, true),
            set: fn($value) => json_encode($value),
        );
    }

    protected function optStatus(): Attribute
    {
        return Attribute::make(
            get: fn($value) => json_decode($value, true),
            set: fn($value) => json_encode($value),
        );
    }
}
