<?php

namespace App\Models\STOCK;

use Illuminate\Database\Eloquent\Model;
use App\Models\PRODUCT\Product;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;
use OwenIt\Auditing\Contracts\Auditable;

class Stocklog extends Model implements Auditable
{
    use HasFactory, SoftDeletes, \OwenIt\Auditing\Auditable;

    protected $table = 'stocklogs';
    protected $fillable = [
        'batch',
        'productId',
        'productName',
        'productCode',
        'operationType',
        'operationCode',
        'quantity',
        'price',
        'unite',
        'operator',
        'operatorId',
        'warehouse',
        'warehouseId',
        'date'
    ];

    protected $casts = [
        'date' => 'datetime',
    ];

    public function product()
    {
        return $this->belongsTo(Product::class, 'productId');
    }
}
