<?php

namespace App\Models\OPERATION;

use App\Models\OPERATION\Operation;
use app\Models\admin\User;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use OwenIt\Auditing\Contracts\Auditable;
use Carbon\Carbon;

class Pos extends Model implements Auditable
{
    use HasFactory, SoftDeletes, \OwenIt\Auditing\Auditable;
    protected $fillable = [
        'name',
        'ref',
        'status',
        'openingBalance',
        //'currentBalance',
        'closingBalance',
        'openedAt',
        'closedAt',
        'userId',
        'cashierId'
    ];

    public function operations()
    {
        return $this->hasMany(Operation::class, 'posId');
    }

    public function owner()
    {
        return $this->belongsTo(User::class, 'userId');
    }

    public function cashier()
    {
        return $this->belongsTo(User::class, 'cashierId');
    }

    protected static function booted()
    {
        static::creating(function ($model) {
            $model->status = "draft";
            // Attach authenticated user
            if ($user = request()->user()) {
                $model->userId ??= $user->id;
            }

            // Auto-generate name: Caisse-#
            if (empty($model->openingBalance)) {
                $model->openingBalance = 0;
            }

            // Auto-generate name: Caisse-#
            if (empty($model->name)) {
                $lastNumber = static::max('id') ?? 0;
                $model->name = 'Caisse-' . ($lastNumber + 1);
            }

            if (empty($model->ref)) {
                $milliseconds = round(microtime(true) * 1000);
                $lastFive = substr($milliseconds, -5);
                $model->ref = 'POS' . $lastFive;
            }
        });
        static::updating(function ($model) {

            if ($model->isDirty('status')) {

                // null -> open OR closed -> open
                if ($model->status === 'open') {
                    $model->openedAt = Carbon::now();
                }

                // open -> closed
                if ($model->status === 'closed') {
                    // If operations are already loaded, use the collection sum
                    if ($model->relationLoaded('operations')) {
                        $closingBalance = $model->operations
                            ->where('docType', 'possale')
                            ->sum('totalTtc');
                    } else {
                        // Otherwise, query the database
                        $closingBalance = $model->operations()
                            ->where('docType', 'possale')
                            ->sum('totalTtc');
                    }
                    $model->closingBalance = $closingBalance  + (float)$model->openingBalance;
                    $model->closedAt = Carbon::now();
                }
            }
        });
    }
}
