<?php

namespace App\Models\MEDIA;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Storage;
use OwenIt\Auditing\Contracts\Auditable;

class Media extends Model implements Auditable
{
    use HasFactory, \OwenIt\Auditing\Auditable;
    protected $fillable = [
        'uid',
        'name',
        'status',
        'path',
        'mime_type',
        'size',
        'disk',
        'type',
    ];

    protected $appends = ['url'];

    public function getUrlAttribute()
    {
        return Storage::disk($this->disk ?? 'public')->url($this->path);
    }

    public function model()
    {
        return $this->morphTo();
    }


    protected static function boot()
    {
        parent::boot();
        static::creating(function ($model) {
            if (empty($model->uid)) {
                $model->uid = (string) Str::ulid();
            }

            if (!empty($model->model_type)) {
                $model->name = $model->model_type;

            }
            if (!empty($model->status)) {
                $model->status = 'active';
            }
        });

        static::updating(function ($model) {
            if ($model->isDirty('model_type')) {
                $model->name = $model->model_type;
            }
        });
    }
}
