<?php

namespace App\Models\ACCOUNTING;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use OwenIt\Auditing\Contracts\Auditable;
use App\Models\ACCOUNTING\Payment;

class Bankaccount extends Model implements Auditable
{
    use HasFactory,  \OwenIt\Auditing\Auditable;

    protected $fillable = [
        'name',
        'type',
        'status',
        'bankName',
        'accountNumber',
        'swift',
        'bic',
        'iban',
        'initial_balance',
        'balance',
        'currency',
        'companyId',
        'description'
    ];

    public function payments(){
        return $this->hasMany(Payment::class);
    }
}
