<?php

namespace App\Models\ACCOUNTING;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use OwenIt\Auditing\Contracts\Auditable;
use App\Models\OPERATION\Operation;
use App\Models\ACCOUNTING\Journal;
use App\Models\ACCOUNTING\Account;

class Accountingentry extends Model implements Auditable
{
    use HasFactory,  \OwenIt\Auditing\Auditable;

    protected $fillable = [
        'operationId',
        'journalId',
        'accountId',
        'debit',
        'credit',
        'entryDate',
    ];

    //create the relationShips

    public function  operation()
    {
        return $this->belongsTo(Operation::class, 'operationId');
    }

    public function  journal()
    {
        return $this->belongsTo(Journal::class, 'journalId');
    }

    public function  account()
    {
        return $this->belongsTo(Account::class, 'accountId');
    }


}
