<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class SendUserPasswordMail extends Mailable
{
    use Queueable, SerializesModels;

    public $email;
    public $password;
    public $name;
    public $companyName;

    /**
     * Create a new message instance.
     */
    public function __construct(string $email,  string $password , string $name, string $companyName)
    {
        $this->email = $email;
        $this->password = $password;
        $this->name = $name;
        $this->companyName = $companyName;
    }

    /**
     * Build the message.
     */
    public function build()
    {
        return $this->subject('Votre compte a été créé')
            ->markdown('emails.user.password');
    }
}
