<?php

namespace App\Jobs;

use Illuminate\Foundation\Queue\Queueable;
use Illuminate\Support\Carbon;
use App\Models\HRM\Leave;

class ChangeLeaveStatus
{
    use Queueable;

    /**
     * Create a new job instance.
     */
    public function __construct()
    {
        //
    }

    /**
     * Execute the job.
     */
    public function handle()
    {
        $today = Carbon::today();

        /**
         * 1. confirmed → ongoing
         * When start date arrives or passes
         */
        Leave::where('status', Leave::STATUS_CONFIRMED)
            ->whereDate('start', '<=', $today)
            ->update(['status' => Leave::STATUS_ONGOING]);


        /**
         * 2. draft/pending/requested → requestExpired
         * When start date arrives or passes
         */
        Leave::whereIn('status', [
            Leave::STATUS_DRAFT,
            Leave::STATUS_PENDING,
            Leave::STATUS_REQUESTED
        ])
            ->whereDate('start', '<=', $today)
            ->update(['status' => Leave::STATUS_REQUEST_EXPIRED]);


        /**
         * 3. ongoing → back
         * When end date has *passed*
         */
        Leave::where('status', Leave::STATUS_ONGOING)
            ->whereDate('end', '<', $today)
            ->update(['status' => Leave::STATUS_BACK]);


        /**
         * 4. back → taken
         * When one day passes after end date
         */
        Leave::where('status', Leave::STATUS_BACK)
            ->whereDate('end', '<=', $today->copy()->subDay())
            ->update(['status' => Leave::STATUS_TAKEN]);
    }
}
